/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public interface CheckList<E> {
    public static final CheckList<?> EMPTY = new CheckList<Object>(){

        @Override
        public boolean check(Object element) {
            return true;
        }

        @Override
        public void uncheck(Object element) {
        }

        @Override
        public boolean checkIf(Predicate<Object> checkPredicate) {
            return true;
        }

        @Override
        public void uncheckIf(Predicate<Object> checkPredicate) {
        }

        @Override
        public void checkAll() {
        }

        @Override
        public void uncheckAll() {
        }

        @Override
        public boolean isChecked(Object column) {
            return false;
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isBlank() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ImmutableSet<Object> getElements() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<Object> getCheckedElements() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<Object> getUncheckedElements() {
            return ImmutableSet.empty();
        }

        @Override
        public void uncheckIfPresent(Object element) {
        }

        @Override
        public Iterable<Object> iterateUncheckedElements() {
            return ImmutableSet.empty();
        }

        @Override
        public Iterable<Object> iterateCheckedElements() {
            return ImmutableSet.empty();
        }
    };

    public static <E> CheckList<E> create(Set<E> elements) {
        return CheckList.create(elements, "element");
    }

    public static <E> CheckList<E> create(Set<E> elements, String elementName) {
        if (elements.size() == 2) {
            Iterator<E> iter = elements.iterator();
            return new TwoElementCheckList<E>(iter.next(), iter.next(), elementName, elements instanceof ImmutableSet ? (ImmutableSet)elements : null);
        }
        return new BasicCheckList<E>(elements, elementName);
    }

    public static <E> CheckList<E> empty() {
        return EMPTY;
    }

    public boolean check(E var1);

    public void uncheck(E var1);

    public void uncheckIfPresent(E var1);

    public boolean checkIf(Predicate<E> var1);

    public void uncheckIf(Predicate<E> var1);

    public void checkAll();

    public void uncheckAll();

    public boolean isChecked(E var1);

    public boolean isComplete();

    public boolean isBlank();

    public int size();

    public ImmutableSet<E> getElements();

    public ImmutableSet<E> getCheckedElements();

    public ImmutableSet<E> getUncheckedElements();

    public Iterable<E> iterateCheckedElements();

    public Iterable<E> iterateUncheckedElements();

    public static class BasicCheckList<E>
    implements CheckList<E> {
        private final ImmutableSet<E> elements;
        private final ImmutableSet.Builder<E> unchecked;
        private final String elementName;
        private int uncheckedCount;
        private int size;

        BasicCheckList(Set<E> elements, String elementName) {
            this.elements = ImmutableSet.of(elements);
            this.unchecked = new ImmutableSet.Builder<E>(this.elements);
            this.uncheckedCount = this.size = this.elements.size();
            this.elementName = elementName;
        }

        @Override
        public boolean check(E element) {
            this.verifyElement(element);
            this.doCheck(element);
            return this.uncheckedCount == 0;
        }

        private void doCheck(E element) {
            if (this.unchecked.contains(element)) {
                this.unchecked.remove(element);
                --this.uncheckedCount;
            }
        }

        @Override
        public void uncheck(E element) {
            this.verifyElement(element);
            this.doUncheck(element);
        }

        @Override
        public void uncheckIfPresent(E element) {
            if (this.elements.contains(element)) {
                this.doUncheck(element);
            }
        }

        private void doUncheck(E element) {
            if (!this.unchecked.contains(element)) {
                this.unchecked.with(element);
                ++this.uncheckedCount;
            }
        }

        @Override
        public boolean checkIf(Predicate<E> checkPredicate) {
            Iterator<E> iter = this.unchecked.iterator();
            while (iter.hasNext()) {
                if (!checkPredicate.test(iter.next())) continue;
                iter.remove();
                --this.uncheckedCount;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public void uncheckIf(Predicate<E> checkPredicate) {
            for (Object element : this.elements) {
                if (this.unchecked.contains(element) || !checkPredicate.test(element)) continue;
                this.unchecked.with(element);
                ++this.uncheckedCount;
            }
        }

        @Override
        public void checkAll() {
            this.unchecked.clear();
            this.uncheckedCount = 0;
        }

        @Override
        public void uncheckAll() {
            this.unchecked.with(this.elements);
            this.uncheckedCount = this.size;
        }

        @Override
        public boolean isChecked(E element) {
            this.verifyElement(element);
            return !this.unchecked.contains(element);
        }

        @Override
        public boolean isComplete() {
            return this.uncheckedCount == 0;
        }

        @Override
        public boolean isBlank() {
            return this.uncheckedCount == this.size;
        }

        @Override
        public int size() {
            return this.size;
        }

        private void verifyElement(E element) {
            if (!this.elements.contains(element)) {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
        }

        @Override
        public ImmutableSet<E> getElements() {
            return this.elements;
        }

        @Override
        public ImmutableSet<E> getCheckedElements() {
            if (this.isComplete()) {
                return this.elements;
            }
            if (this.isBlank()) {
                return ImmutableSet.empty();
            }
            return this.elements.matching(e -> !this.unchecked.contains(e));
        }

        @Override
        public ImmutableSet<E> getUncheckedElements() {
            if (this.isComplete()) {
                return ImmutableSet.empty();
            }
            if (this.isBlank()) {
                return this.elements;
            }
            return this.elements.matching(e -> this.unchecked.contains(e));
        }

        @Override
        public Iterable<E> iterateCheckedElements() {
            if (this.isComplete()) {
                return this.elements;
            }
            if (this.isBlank()) {
                return ImmutableSet.empty();
            }
            return this.elements.iterateMatching(e -> !this.unchecked.contains(e));
        }

        @Override
        public Iterable<E> iterateUncheckedElements() {
            if (this.isComplete()) {
                return ImmutableSet.empty();
            }
            if (this.isBlank()) {
                return this.elements;
            }
            return this.elements.iterateMatching(e -> this.unchecked.contains(e));
        }
    }

    public static class TwoElementCheckList<E>
    implements CheckList<E> {
        private final E e1;
        private final E e2;
        private final String elementName;
        private ImmutableSet<E> elements;
        private boolean e1checked;
        private boolean e2checked;

        TwoElementCheckList(E e1, E e2, String elementName) {
            this.e1 = e1;
            this.e2 = e2;
            this.elementName = elementName;
        }

        TwoElementCheckList(E e1, E e2, String elementName, ImmutableSet<E> elements) {
            this.e1 = e1;
            this.e2 = e2;
            this.elementName = elementName;
            this.elements = elements;
        }

        @Override
        public boolean check(E element) {
            if (element.equals(this.e1)) {
                this.e1checked = true;
            } else if (element.equals(this.e2)) {
                this.e2checked = true;
            } else {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            return this.e1checked && this.e2checked;
        }

        @Override
        public void uncheck(E element) {
            if (element.equals(this.e1)) {
                this.e1checked = false;
            } else if (element.equals(this.e2)) {
                this.e2checked = false;
            } else {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
        }

        @Override
        public void uncheckIfPresent(E element) {
            if (element.equals(this.e1)) {
                this.e1checked = false;
            } else if (element.equals(this.e2)) {
                this.e2checked = false;
            }
        }

        @Override
        public boolean checkIf(Predicate<E> checkPredicate) {
            if (!this.e1checked && checkPredicate.test(this.e1)) {
                this.e1checked = true;
            }
            if (!this.e2checked && checkPredicate.test(this.e2)) {
                this.e2checked = true;
            }
            return this.e1checked && this.e2checked;
        }

        @Override
        public void uncheckIf(Predicate<E> checkPredicate) {
            if (this.e1checked && checkPredicate.test(this.e1)) {
                this.e1checked = false;
            }
            if (this.e2checked && checkPredicate.test(this.e2)) {
                this.e2checked = false;
            }
        }

        @Override
        public void checkAll() {
            this.e1checked = true;
            this.e2checked = true;
        }

        @Override
        public void uncheckAll() {
            this.e1checked = false;
            this.e2checked = false;
        }

        @Override
        public boolean isChecked(E element) {
            if (element.equals(this.e1)) {
                return this.e1checked;
            }
            if (element.equals(this.e2)) {
                return this.e2checked;
            }
            throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
        }

        @Override
        public boolean isComplete() {
            return this.e1checked && this.e2checked;
        }

        @Override
        public boolean isBlank() {
            return !this.e1checked && !this.e2checked;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public ImmutableSet<E> getElements() {
            if (this.elements == null) {
                this.elements = ImmutableSet.of(this.e1, this.e2);
            }
            return this.elements;
        }

        @Override
        public ImmutableSet<E> getCheckedElements() {
            if (this.e1checked) {
                if (this.e2checked) {
                    return this.getElements();
                }
                return ImmutableSet.of(this.e1);
            }
            if (this.e2checked) {
                return ImmutableSet.of(this.e2);
            }
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<E> getUncheckedElements() {
            if (this.e1checked) {
                if (this.e2checked) {
                    return ImmutableSet.empty();
                }
                return ImmutableSet.of(this.e2);
            }
            if (this.e2checked) {
                return ImmutableSet.of(this.e1);
            }
            return this.getElements();
        }

        @Override
        public Iterable<E> iterateCheckedElements() {
            return this.getCheckedElements();
        }

        @Override
        public Iterable<E> iterateUncheckedElements() {
            return this.getUncheckedElements();
        }
    }
}

